const endpoint = '/follow_handler';
function update_follow_links(my_pk, following, server_url = '') {
    const follow_icon = bsi('person_plus'), following_icon = bsi('person_check');
    try {
        $('.follow-btn').add('.me-span').remove();
        $('.user-profile-link').each(function() {
            $(this).addClass('follow-link-processing-done');
            const public_key = $(this).data('public-key');
            if (public_key == my_pk) {
                const me_span = $(`<span class="text text-muted small me-span" style="padding-left:6px;" data-public-key="${my_pk}">me</span>`);
                $(this).after(me_span);
                $(this).addClass('me');
                return;
            }
            const is_following = following.includes(public_key);
            const link_text = is_following ? following_icon : '<span class="small"><span class="small">follow</span></span>' + follow_icon;
            const follow_class = is_following ? '' : 'text-muted';
            const follow_link = $(`<a class="follow-btn ${follow_class}" data-public-key="${public_key}" style="padding-left:6px;">${link_text}</a>`);
            follow_link.on('click', function() {
                $(this).animate({ opacity: 0 }, 200);
                const pk = $(this).data('public-key');
                const jwt = localStorage.getItem('jwt');
                if (!jwt) {
                    return;
                }
                const headers = { 'Authorization': `Bearer ${jwt}` };
                $.ajax({
                    url: `${server_url}${endpoint}`,
                    type: 'POST',
                    headers: headers,
                    data: JSON.stringify({ public_key: pk }), // follows and/or unfollows
                    contentType: 'application/json',
                    success: function(data) {
                        update_follow_links((data?.my_pk || null), (data?.following || []));
                    }
                });
            });
            $(this).after(follow_link);
        });
    } catch (e) {
        console.error(e);
    }
}
function init_follow_links(server_url = '') {
    const jwt = localStorage.getItem('jwt');
    if (!jwt) {
        return;
    }
    const headers = { 'Authorization': `Bearer ${jwt}` };
    $.ajax({
        url: `${server_url}${endpoint}`,
        type: 'GET',
        headers: headers,
        success: function(data) {
            try {
                const my_pk = data.my_pk;
                const following = data.following; // list of public keys I follow
                update_follow_links(my_pk, following, server_url);
            } catch (e) {
                console.error(e);
            }
        }
    });
}
function clone_follow_links(server_url = '') {
    const pks = []; // Public keys that require follow links or me spans
    var skipped = 0;
    $('.user-profile-link:not(.follow-link-processing-done)').each(function() {
        const public_key = $(this).data('public-key');
        if (public_key && !pks.includes(public_key)) {
            pks.push(public_key);
        }
    });
    for (const pk of pks) {
        const follow_link = $(`.follow-btn[data-public-key="${pk}"]`);
        const me_span = $(`.me-span[data-public-key="${pk}"]`);
        if (follow_link.length > 0) {
            const clone = follow_link.first().clone();
            $(`.user-profile-link[data-public-key="${pk}"]`).each(function() {
                $(this).after(clone.clone());
                $(this).addClass('follow-link-processing-done');
            });
            continue;
        }
        if (me_span.length > 0) {
            const clone = me_span.first().clone();
            $(`.user-profile-link[data-public-key="${pk}"]`).each(function() {
                $(this).after(clone.clone());
                $(this).addClass('follow-link-processing-done').addClass('me');
            });
            continue;
        }
        skipped += 1;
    }
    if (skipped > 0) {
        init_follow_links(server_url); // New chats have been added dynamically, re-init follow links
    }
}